//Analysis of Unsymmetrical Fault in Power Systems//
//This program requires user input. A sample problem with user input and output is available in the result file//
clc ;
clear;
a=input('Enter the positve,negative  and zero sequence of first generator in matrix form:')
PSG1=a(:,1); //positive sequence of Generator 1
NSG1=a(:,2); //negative sequence of Generator 1
ZSG1=a(:,3); //zero sequence of Generator 1
b=input('Enter the positve,negative and zero sequence of first transformer in matrix form:')
PST1=b(:,1); //positive sequence of Transformer 1
NST1=b(:,2); //negative sequence of Transformer 1
ZST1=b(:,3); //zero sequence of Transformer 1
c=input('Enter the positve,negative and zero sequence of first transmission line in matrix form:')
PSTL=c(:,1); //positive sequence of Transmission Line
NSTL=c(:,2); //negative sequence of Transmission Line
ZSTL=c(:,3); //zero sequence of Transmission Line
d=input('Enter the positve,negative and zero sequence of second transformer in matrix form:')
PST2=d(:,1); //positive sequence of Transformer 2
NST2=d(:,2); //negative sequence of Transformer 2
ZST2=d(:,3); //zero sequence of Transformer 2
e=input('Enter the positive,negative and zero sequence of second generator in matrix form:')
PSG2=e(:,1); //positive sequence of Generator 2
NSG2=e(:,2); //negative sequence of Generator 2
ZSG2=e(:,3); //zero sequence of Generator 2
MVAB=input('Enter the value of base MVA:');
KVB=input('Enter the value of base KV:');
z1=((PSG1*%i+PST1*%i)*(PSTL*%i+PST2*%i+PSG2*%i))/((PSG1*%i+PST1*%i)+(PSTL*%i+PST2*%i+PSG2*%i));//positive Sequence impedence
z2=((NSG1*%i+NST1*%i)*(NSTL*%i+NST2*%i+NSG2*%i))/((NSG1*%i+NST1*%i)+(NSTL*%i+NST2*%i+NSG2*%i));//Negative Sequence impedence
z0=((ZSG1*%i+ZST1*%i)*(ZSTL*%i+ZST2*%i+ZSG2*%i))/((ZSG1*%i+ZST1*%i)+(ZSTL*%i+ZST2*%i+ZSG2*%i));//Zero Sequence impedence
Ib=(MVAB*(10^6))/((1.732*KVB*(10^3)))//calculating base current
disp(z0,z2,z1,'The values of Positive(z1) Negative(z2) and Zero(z0) sequence impedances are respectively');
disp('OPTION','LG FAULT=1','LL FAULT=2','LLG FAULT=3');
MENU=input('Enter the choice of fault:')
if MENU==1 //calculating Line to Ground fault
    If=(3*(1))/(z0+z1+z2)
    Faultycurrent=If*Ib;
    disp(Faultycurrent,'The fault current is :');
end
if MENU==2//Calculating Line to Line Fault
    If=((-1.732*(%i))*(1))/(z1+z2)
    Faultycurrent=If*Ib;
disp(Faultycurrent,'The fault current is :');
end
if MENU==3//calculating Line-Line-Ground fault
    z=(z0*z2)/(z0+z2);
    Ia1=(1)/(z1+z);
    Ia0=((-1+(Ia1*z1))/z0);
    If=3*Ia0;
    Faultycurrent=If*Ib;
 disp(Faultycurrent,'The fault current is :');
end

 //Sample Input and Output
//Enter the positve,negative  and zero sequence of first generator in matrix form:[0.25 0.29 0.28]
//Enter the positve,negative and zero sequence of first transformer in matrix form:[0.48 0.47 0.49]
//Enter the positve,negative and zero sequence of first transmission line in matrix form:[0.20 0.22 0.24]
//Enter the positve,negative and zero sequence of second transformer in matrix form:[0.18 0.22 0.24]
//Enter the positive,negative and zero sequence of second generator in matrix form:[0.19 0.17 0.20]
//Enter the value of base MVA:100
//Enter the value of base KV:110
 
//The values of Positive(z1) Negative(z2) and Zero(z0) sequence impedances are respectively   
 
//    0.3200769i  
 
//    0.3383942i  
 
//    0.3611034i  
 
// LLG FAULT=3   
 
// LL FAULT=2   
 
// LG FAULT=1   
 
// OPTION   
//Enter the choice of fault:1
 
// The fault current is :   
 
//  - 1544.4068i  
